// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "messages.h"
#include "stringCommons.h"
#include "degub.h"
#include <Mmsystem.h>

#define MOVE_MACRO(identifier) case identifier: return #identifier;

string TranslateCN(WORD note) {
	switch(note) {
		MOVE_MACRO(EN_SETFOCUS)
		MOVE_MACRO(EN_KILLFOCUS)
		MOVE_MACRO(EN_CHANGE)
		MOVE_MACRO(EN_UPDATE)
		MOVE_MACRO(EN_ERRSPACE)
		MOVE_MACRO(EN_MAXTEXT)
		MOVE_MACRO(EN_HSCROLL)
		MOVE_MACRO(EN_VSCROLL)
	default:
		{
			ostringstream str;
			str << HEX0x0(4, note);
			return str.str();
		}
	}
}

string TranslateCDEE(DWORD error) {
	switch(error) {
		MOVE_MACRO(CDERR_DIALOGFAILURE)

		MOVE_MACRO(CDERR_GENERALCODES)
		MOVE_MACRO(CDERR_STRUCTSIZE)
		MOVE_MACRO(CDERR_INITIALIZATION)
		MOVE_MACRO(CDERR_NOTEMPLATE)
		MOVE_MACRO(CDERR_NOHINSTANCE)
		MOVE_MACRO(CDERR_LOADSTRFAILURE)
		MOVE_MACRO(CDERR_FINDRESFAILURE)
		MOVE_MACRO(CDERR_LOADRESFAILURE)
		MOVE_MACRO(CDERR_LOCKRESFAILURE)
		MOVE_MACRO(CDERR_MEMALLOCFAILURE)
		MOVE_MACRO(CDERR_MEMLOCKFAILURE)
		MOVE_MACRO(CDERR_NOHOOK)
		MOVE_MACRO(CDERR_REGISTERMSGFAIL)

		MOVE_MACRO(PDERR_PRINTERCODES)
		MOVE_MACRO(PDERR_SETUPFAILURE)
		MOVE_MACRO(PDERR_PARSEFAILURE)
		MOVE_MACRO(PDERR_RETDEFFAILURE)
		MOVE_MACRO(PDERR_LOADDRVFAILURE)
		MOVE_MACRO(PDERR_GETDEVMODEFAIL)
		MOVE_MACRO(PDERR_INITFAILURE)
		MOVE_MACRO(PDERR_NODEVICES)
		MOVE_MACRO(PDERR_NODEFAULTPRN)
		MOVE_MACRO(PDERR_DNDMMISMATCH)
		MOVE_MACRO(PDERR_CREATEICFAILURE)
		MOVE_MACRO(PDERR_PRINTERNOTFOUND)
		MOVE_MACRO(PDERR_DEFAULTDIFFERENT)

		MOVE_MACRO(CFERR_CHOOSEFONTCODES)
		MOVE_MACRO(CFERR_NOFONTS)
		MOVE_MACRO(CFERR_MAXLESSTHANMIN)

		MOVE_MACRO(FNERR_FILENAMECODES)
		MOVE_MACRO(FNERR_SUBCLASSFAILURE)
		MOVE_MACRO(FNERR_INVALIDFILENAME)
		MOVE_MACRO(FNERR_BUFFERTOOSMALL)

		MOVE_MACRO(FRERR_FINDREPLACECODES)
		MOVE_MACRO(FRERR_BUFFERLENGTHZERO)

		MOVE_MACRO(CCERR_CHOOSECOLORCODES)
	default:
		{
			ostringstream str;
			str << HEX0x08(error);
			return str.str();
		}
	}
}

string TranslateMCIE(DWORD code) {
	switch(code) {
		MOVE_MACRO(MMSYSERR_NOERROR)
		MOVE_MACRO(MMSYSERR_ERROR)
		MOVE_MACRO(MMSYSERR_BADDEVICEID)
		MOVE_MACRO(MMSYSERR_NOTENABLED)
		MOVE_MACRO(MMSYSERR_ALLOCATED)
		MOVE_MACRO(MMSYSERR_INVALHANDLE)
		MOVE_MACRO(MMSYSERR_NODRIVER)
		MOVE_MACRO(MMSYSERR_NOMEM)
		MOVE_MACRO(MMSYSERR_NOTSUPPORTED)
		MOVE_MACRO(MMSYSERR_BADERRNUM)
		MOVE_MACRO(MMSYSERR_INVALFLAG)
		MOVE_MACRO(MMSYSERR_INVALPARAM)
		MOVE_MACRO(MMSYSERR_HANDLEBUSY)
		MOVE_MACRO(MMSYSERR_INVALIDALIAS)
		MOVE_MACRO(MMSYSERR_BADDB)
		MOVE_MACRO(MMSYSERR_KEYNOTFOUND)
		MOVE_MACRO(MMSYSERR_READERROR)
		MOVE_MACRO(MMSYSERR_WRITEERROR)
		MOVE_MACRO(MMSYSERR_DELETEERROR)
		MOVE_MACRO(MMSYSERR_VALNOTFOUND)
		MOVE_MACRO(MMSYSERR_NODRIVERCB)
		MOVE_MACRO(MMSYSERR_MOREDATA)
	default:
		{
			ostringstream str;
			str << "Unknown MCI Error: " << HEX0x08(code);
			return str.str();
		}
	}
}

#define MOVE_UE(ue, desc) case ue: return #ue;
extern const char* gle_array[ERROR_INSTALL_TRANSFORM_REJECTED + 1];

string TranslateGLE(DWORD error) {
	if(error <= ERROR_INSTALL_TRANSFORM_REJECTED && gle_array[error] != NULL)
		return gle_array[error];
	else switch(error) {
		UE_ERROR_CODES(MOVE_UE)

		MOVE_MACRO(UE_NO_ERROR)
		MOVE_MACRO(_UE_SIZE)
	default:
		{
			ostringstream str;
			str << HEX0x08(error);
			return str.str();
		}
	}
}

extern const char* wm_array[WM_PENWINLAST + 1];

string TranslateWM(DWORD message) {
	if(message <= WM_PENWINLAST && wm_array[message] != NULL)
		return wm_array[message];

	std::ostringstream str;
	if(message >= WM_APP && message < WM_APP * 2) {
		str << "WM_APP + " << (message - WM_APP);
	} else {
		switch(message) {
			LAZER_MESSAGES(MOVE_MACRO)
		default:
			str << HEX0x(message);
		}
	}

	return str.str();
}

string TranslateWSAErr(int code) {
	switch(code) {
		MOVE_MACRO(WSABASEERR)
			/*
			* Windows Sockets definitions of regular Microsoft C error constants
			*/
		MOVE_MACRO(WSAEINTR)
		MOVE_MACRO(WSAEBADF)
		MOVE_MACRO(WSAEACCES)
		MOVE_MACRO(WSAEFAULT)
		MOVE_MACRO(WSAEINVAL)
		MOVE_MACRO(WSAEMFILE)

			/*
			* Windows Sockets definitions of regular Berkeley error constants
			*/
		MOVE_MACRO(WSAEWOULDBLOCK)
		MOVE_MACRO(WSAEINPROGRESS)
		MOVE_MACRO(WSAEALREADY)
		MOVE_MACRO(WSAENOTSOCK)
		MOVE_MACRO(WSAEDESTADDRREQ)
		MOVE_MACRO(WSAEMSGSIZE)
		MOVE_MACRO(WSAEPROTOTYPE)
		MOVE_MACRO(WSAENOPROTOOPT)
		MOVE_MACRO(WSAEPROTONOSUPPORT)
		MOVE_MACRO(WSAESOCKTNOSUPPORT)
		MOVE_MACRO(WSAEOPNOTSUPP)
		MOVE_MACRO(WSAEPFNOSUPPORT)
		MOVE_MACRO(WSAEAFNOSUPPORT)
		MOVE_MACRO(WSAEADDRINUSE)
		MOVE_MACRO(WSAEADDRNOTAVAIL)
		MOVE_MACRO(WSAENETDOWN)
		MOVE_MACRO(WSAENETUNREACH)
		MOVE_MACRO(WSAENETRESET)
		MOVE_MACRO(WSAECONNABORTED)
		MOVE_MACRO(WSAECONNRESET)
		MOVE_MACRO(WSAENOBUFS)
		MOVE_MACRO(WSAEISCONN)
		MOVE_MACRO(WSAENOTCONN)
		MOVE_MACRO(WSAESHUTDOWN)
		MOVE_MACRO(WSAETOOMANYREFS)
		MOVE_MACRO(WSAETIMEDOUT)
		MOVE_MACRO(WSAECONNREFUSED)
		MOVE_MACRO(WSAELOOP)
		MOVE_MACRO(WSAENAMETOOLONG)
		MOVE_MACRO(WSAEHOSTDOWN)
		MOVE_MACRO(WSAEHOSTUNREACH)
		MOVE_MACRO(WSAENOTEMPTY)
		MOVE_MACRO(WSAEPROCLIM)
		MOVE_MACRO(WSAEUSERS)
		MOVE_MACRO(WSAEDQUOT)
		MOVE_MACRO(WSAESTALE)
		MOVE_MACRO(WSAEREMOTE)

			/*
			* Extended Windows Sockets error constant definitions
			*/
		MOVE_MACRO(WSASYSNOTREADY)
		MOVE_MACRO(WSAVERNOTSUPPORTED)
		MOVE_MACRO(WSANOTINITIALISED)
		MOVE_MACRO(WSAEDISCON)
		MOVE_MACRO(WSAENOMORE)
		MOVE_MACRO(WSAECANCELLED)
		MOVE_MACRO(WSAEINVALIDPROCTABLE)
		MOVE_MACRO(WSAEINVALIDPROVIDER)
		MOVE_MACRO(WSAEPROVIDERFAILEDINIT)
		MOVE_MACRO(WSASYSCALLFAILURE)
		MOVE_MACRO(WSASERVICE_NOT_FOUND)
		MOVE_MACRO(WSATYPE_NOT_FOUND)
		MOVE_MACRO(WSA_E_NO_MORE)
		MOVE_MACRO(WSA_E_CANCELLED)
		MOVE_MACRO(WSAEREFUSED)

		MOVE_MACRO(WSAHOST_NOT_FOUND)
		MOVE_MACRO(WSATRY_AGAIN)
		MOVE_MACRO(WSANO_RECOVERY)
		MOVE_MACRO(WSANO_DATA)

		MOVE_MACRO(WSA_QOS_RECEIVERS)
		MOVE_MACRO(WSA_QOS_SENDERS)
		MOVE_MACRO(WSA_QOS_NO_SENDERS)
		MOVE_MACRO(WSA_QOS_NO_RECEIVERS)
		MOVE_MACRO(WSA_QOS_REQUEST_CONFIRMED)
		MOVE_MACRO(WSA_QOS_ADMISSION_FAILURE)
		MOVE_MACRO(WSA_QOS_POLICY_FAILURE)
		MOVE_MACRO(WSA_QOS_BAD_STYLE)
		MOVE_MACRO(WSA_QOS_BAD_OBJECT)
		MOVE_MACRO(WSA_QOS_TRAFFIC_CTRL_ERROR)
		MOVE_MACRO(WSA_QOS_GENERIC_ERROR)
		MOVE_MACRO(WSA_QOS_ESERVICETYPE)
		MOVE_MACRO(WSA_QOS_EFLOWSPEC)
		MOVE_MACRO(WSA_QOS_EPROVSPECBUF)
		MOVE_MACRO(WSA_QOS_EFILTERSTYLE)
		MOVE_MACRO(WSA_QOS_EFILTERTYPE)
		MOVE_MACRO(WSA_QOS_EFILTERCOUNT)
		MOVE_MACRO(WSA_QOS_EOBJLENGTH)
		MOVE_MACRO(WSA_QOS_EFLOWCOUNT)
		MOVE_MACRO(WSA_QOS_EUNKOWNPSOBJ)
		MOVE_MACRO(WSA_QOS_EPOLICYOBJ)
		MOVE_MACRO(WSA_QOS_EFLOWDESC)
		MOVE_MACRO(WSA_QOS_EPSFLOWSPEC)
		MOVE_MACRO(WSA_QOS_EPSFILTERSPEC)
		MOVE_MACRO(WSA_QOS_ESDMODEOBJ)
		MOVE_MACRO(WSA_QOS_ESHAPERATEOBJ)
		MOVE_MACRO(WSA_QOS_RESERVED_PETYPE)

			/*
			* WinSock 2 extension -- new error codes and type definition
			*/
			/*MOVE_MACRO(WSA_IO_PENDING)
		MOVE_MACRO(WSA_IO_INCOMPLETE)
		MOVE_MACRO(WSA_INVALID_HANDLE)
		MOVE_MACRO(WSA_INVALID_PARAMETER)
		MOVE_MACRO(WSA_NOT_ENOUGH_MEMORY)
		MOVE_MACRO(WSA_OPERATION_ABORTED)

		MOVE_MACRO(WSA_INVALID_EVENT)
		MOVE_MACRO(WSA_MAXIMUM_WAIT_EVENTS)
		MOVE_MACRO(WSA_WAIT_FAILED)
		MOVE_MACRO(WSA_WAIT_EVENT_0)
		MOVE_MACRO(WSA_WAIT_IO_COMPLETION)
		MOVE_MACRO(WSA_WAIT_TIMEOUT)
		MOVE_MACRO(WSA_INFINITE)*/
	default:
		{
			ostringstream str;
			str << "Unknown WSA error: " << HEX0x08(code);
			return str.str();
		}
	}
}
